// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
extern _Cilk_shared myo_attach_gdb();

_Cilk_shared int global = 42;

_Cilk_shared target() {
    volatile int bp = 0;
    global++;
    bp = global;        /* force_read_global */
}


int main(int argc, char* argv[]) {
    _Cilk_offload myo_attach_gdb();

    volatile int dummy = 0;

    // dummy assignments are used to force a Shared variable read
    dummy = global;
    global++;

    _Cilk_offload target();
    dummy = global;
    global++;

    _Cilk_offload target();
    global++;

    _Cilk_offload target();
    global++;

    dummy = 1;

    return 0;
}
