/* Python/gdb header for generic use in gdb

   Modified by Linaro.
   Copyright (C) March 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
   
   Modified by Arm.
   Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.
   
   Copyright (C) 2008-2024 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#ifndef GDB_PYTHON_PYTHON_H
#define GDB_PYTHON_PYTHON_H

#include "extension.h"

/* This is all that python exports to gdb.  */
extern const struct extension_language_defn extension_language_python;

/* Command element for the 'python' command.  */
extern cmd_list_element *python_cmd_element;

/* The "current" objfile.  This is set when gdb detects that a new
   objfile has been loaded.  It is only set for the duration of a call to
   gdbpy_source_objfile_script and gdbpy_execute_objfile_script; it is NULL
   at other times.  */
extern struct objfile *gdbpy_current_objfile;

struct value *apply_val_child (struct value *object,
			       struct value *index,
			       const struct language_defn *language);

#endif /* GDB_PYTHON_PYTHON_H */
