/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef MULTIINDEXABSTRACTITEMDELEGATE_H
#define MULTIINDEXABSTRACTITEMDELEGATE_H

#include "texteditor_global.h"

#include <QStyledItemDelegate>

//! Extension to QAbstractItemDelegate that can paint the result of merging a number of QModelIndex objects
/*! Used by BaseTextEditorWidget to draw line annotations for folded code blocks. The new paint method
 *  will be called when a list of all the QModelIndex objects for each of the lines in the folded
 *  block. */
class TEXTEDITOR_EXPORT MultiIndexAbstractItemDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit MultiIndexAbstractItemDelegate(QObject *parent = 0);
    virtual ~MultiIndexAbstractItemDelegate() {}

    //! Paint a representation of the combination of the specified model indexes
    /*! The default implemention prints does nothing (folded blocks will have no annotation).
     *  Subclass and override if such annotations are desired. */
    virtual void paintMultiple(QPainter *painter, const QStyleOptionViewItem &option,
                  const QList<QModelIndex> &indexes) const
    {
        Q_UNUSED(painter); Q_UNUSED(option); Q_UNUSED(indexes);
    }

    //! Returns a tooltip string for the combination of the specified model indexes
    /*! The default implementation prints the tooltip for the first index in the list.
     *  Subclass and override if tooltips showing merged data for all lines in folded blocks
     *  are desired */
    virtual QString multipleIndexTooltipText(const QList<QModelIndex> &indexes) const;

    //! Returns a tooltip string for the the specified index
    virtual QString indexToolTipText(const QModelIndex& index) const;
};

#endif // MULTIINDEXABSTRACTITEMDELEGATE_H
