/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef TERMINALWIDGET_H
#define TERMINALWIDGET_H

#include <QAction>
#include <QMenu>
#include <QProcess>
#include <QTextEdit>
#include "lgpl_gui_export.h"

class QTextDecoder;
class Terminal;
class LGPL_GUI_EXPORT TerminalWidget : public QTextEdit
{
    Q_OBJECT
public:
    explicit TerminalWidget(Terminal *terminal, QWidget *parent = 0);
    explicit TerminalWidget(QWidget *parent = 0);
    ~TerminalWidget();
    void setTerminal(Terminal *terminal);
    Terminal *terminal() const;
    virtual QSize sizeHint() const override;
    virtual QSize minimumSizeHint() const override;
signals:
    void returnPressed();
protected:
    virtual void contextMenuEvent(QContextMenuEvent *event) override;
    virtual void keyPressEvent(QKeyEvent * event) override;
    virtual void paintEvent(QPaintEvent *e) override;
private slots:
    void windowSizeChanged(int columns, int rows);
    void terminalReadyRead();
    void processFinished(int exitCode, QProcess::ExitStatus exitStatus);
    void processStarted(const QString& commandLine);
    void pasteFromClipboard();
private:
    void appendBytes(const char *c, int len);
    void appendString(const QString& s);
    void init();

    QByteArray mBuf;
    QTextCursor mTerminalCursor;
    Terminal *mTerminal;
    QTextDecoder *mDecoder;
    QMenu *mMenu;
    QAction *pasteAction;
};

#endif // TERMINALWIDGET_H
