/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef TERMINALUTIL_H
#define TERMINALUTIL_H

#include <QFont>
#include <QString>
#include <QStringList>
#include "lgpl_gui_export.h"

extern QStringList LGPL_GUI_EXPORT parseCombinedArgString(const QString &program);
#if defined (Q_OS_WIN)
extern QString LGPL_GUI_EXPORT qt_create_commandline(const QString &program, const QStringList &arguments);
#endif  // Q_OS_WIN
extern QFont LGPL_GUI_EXPORT findGoodFont(int size);

#endif // TERMINALUTIL_H
