/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <QApplication>
#include <QProcess>
#include <QTextStream>

#include <stdlib.h>

#include "terminal.h"
#include "terminalprocess.h"
#include "terminalwindow.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTextStream out(stdout);
    if (argc==1)
    {
        out << "Usage:\n" 
            << "  $ " << QString(argv[0]) << " <hostname>\n";
        return EXIT_FAILURE;
    }

    QScopedPointer<Terminal> terminal(new Terminal());
    QScopedPointer<TerminalWindow> window(new TerminalWindow(terminal.data()));
    terminal->openManager();
    QScopedPointer<TerminalProcess> process(new TerminalProcess(terminal.data()));
    process->start(QString("ssh"), QStringList() << QString(argv[1]));
    window->show();

    a.setQuitOnLastWindowClosed(true);
    return a.exec();
}
