/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QRINGBUFFER_P_H
#define QRINGBUFFER_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of a number of Qt sources files.  This header file may change from
// version to version without notice, or even be removed.
//
// We mean it.
//

#include "lgpl_core_export.h"
#include <qbytearray.h>
#include <qlist.h>

class DDTRingBuffer;

class RingBufferCursor {
public:
    RingBufferCursor();
    RingBufferCursor(DDTRingBuffer *buffer);
    ~RingBufferCursor();
    operator int() const;
    RingBufferCursor& operator=(const RingBufferCursor &other);
    RingBufferCursor& operator=(int pos);
    RingBufferCursor& operator+=(int delta);
    RingBufferCursor& operator-=(int delta);
    RingBufferCursor& operator++();
    RingBufferCursor operator++(int);
    RingBufferCursor& operator--();
    RingBufferCursor operator--(int);
private:
    DDTRingBuffer *mBuffer;
    int mPos;
};

class LGPL_CORE_EXPORT DDTRingBuffer
{
public:
    DDTRingBuffer(int growth = 4096);

    int nextDataBlockSize() const;

    const char *readPointer() const;

    // access the bytes at a specified position
    // the out-variable length will contain the amount of bytes readable
    // from there, e.g. the amount still the same QByteArray
    const char *readPointerAtPosition(qint64 pos, qint64 &length) const;

    char at(qint64 pos) const;

    void free(int bytes);

    char *reserve(int bytes);

    void truncate(int pos);

    void chop(int bytes);

    bool isEmpty() const;

    int getChar();

    void putChar(char c);

    void ungetChar(char c);

    int size() const;

    void clear();

    int indexOf(char c, int from = 0) const;

    int indexOf(const QByteArray& s, int from = 0) const;

    int read(char *data, int maxLength);

    QByteArray read(int maxLength);

    QByteArray readAll();

    // read an unspecified amount (will read the first buffer)
    QByteArray read();

    QByteArray mid(int pos, int maxLength = -1) const;

    // append a new buffer to the end
    void append(const QByteArray &qba);

    QByteArray peek(int maxLength) const;

    void skip(int length);

    int readLine(char *data, int maxLength);

    bool canReadLine() const;

    void remove(int from, int length);

    void dump() const;

    qint64 readData(char * data, qint64 maxlen);

private:
    void addCursor(RingBufferCursor *cursor);
    void removeCursor(RingBufferCursor *cursor);
    void updateCursors(int offset, int removed);

    QList<QByteArray> buffers;
    QList<RingBufferCursor *> cursors;
    mutable QByteArray overlap;
    int head, tail;
    int tailBuffer; // always buffers.size() - 1
    int basicBlockSize;
    int bufferSize;

friend class RingBufferCursor;
};

//QT_END_NAMESPACE

#endif // QRINGBUFFER_P_H
