/****************************************************************************
**
** Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
** Copyright (C) 2013-2023 Arm Limited (or its affiliates).
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**********************************************************************/
#ifndef QPIPEREADER_P_H
#define QPIPEREADER_P_H

#include "qpipereader.h"
#include "qringbuffer_p.h"

class QSocketNotifier;

class QPipeReaderPrivate
{
    Q_DECLARE_PUBLIC(QPipeReader)
public:
    QPipeReaderPrivate();
    ~QPipeReaderPrivate();

    // private slots
    bool _q_canRead(bool drain = false);

    qint64 read(char* data, qint64 maxlen);
    qint64 bytesAvailable() const;
    void setPipeDescriptor(Q_PIPE pipe, bool blocking = true);
    void close();

    QObject* q_ptr;

    DDTRingBuffer buffer;
    QSocketNotifier* notifier;
    QFile* logFile;
    Q_PIPE pipe;
    bool eof;
    bool blocking;
    bool enabled;
private:
    void closePipe();
    void createNotifier();
};

#endif  // !QPIPEREADER_P_H
