/****************************************************************************
**
** Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
** Copyright (C) 2009-2023 Arm Limited (or its affiliates).
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**********************************************************************/

#ifndef QPIPEREADER_H
#define QPIPEREADER_H

#include "lgpl_core_export.h"

#include <QIODevice>
#include <QFile>

#ifdef Q_OS_WIN
#include "QtCore/qt_windows.h"
typedef HANDLE Q_PIPE;
#define INVALID_Q_PIPE INVALID_HANDLE_VALUE
#else
typedef int Q_PIPE;
#define INVALID_Q_PIPE -1
#endif

class QPipeReaderPrivate;
class DDTRingBuffer;

class LGPL_CORE_EXPORT QPipeReader : public QIODevice
{
    Q_OBJECT
public:
    QPipeReader( QObject *parent = 0 );
    ~QPipeReader();
    using QIODevice::open; // Don't hide base class methods
    bool open(Q_PIPE pipe, OpenMode mode);
    bool open(const QString& filename, OpenMode mode);
    void close() override;
    qint64 bytesAvailable() const override;
    bool canReadLine() const override;
    bool atEnd() const override;
    bool isSequential() const override;
    bool isEof() const;
    Q_PIPE fd() const;
    void drain();
    const DDTRingBuffer *buffer() const;
    DDTRingBuffer *buffer();
    void setLogFile(QFile *logFile);
    QFile *logFile() const;
    void setEnabled(bool enabled);
    bool isEnabled() const;
protected:
    qint64 readData ( char * data, qint64 maxSize ) override;
    qint64 writeData ( const char * data, qint64 maxSize ) override;
Q_SIGNALS:
    void eof();
    void readError();
private:
    Q_DECLARE_PRIVATE(QPipeReader)
    Q_DISABLE_COPY(QPipeReader)
    Q_PRIVATE_SLOT(d_func(), bool _q_canRead())
    //Q_PRIVATE_SLOT(d_func(), void _q_notified())
    const QScopedPointer<QPipeReaderPrivate> d_ptr;
};

#endif
