/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "coroutinecont.h"

CoroutineCont::CoroutineCont(Coroutine *coroutine, QObject *parent) :
    QObject(parent),
    mCoroutine(coroutine)
{
}

void CoroutineCont::cont()
{
    mCoroutine->cont();
}

void CoroutineCont::yieldUntil(QObject *sender, const char *signal)
{
    CoroutineCont cont(Coroutine::currentCoroutine());
    connect(sender, signal, &cont, SLOT(cont()));
    Coroutine::yield();
}

void CoroutineCont::yieldUntil(QObject *sender, const char *sig1, const char *sig2)
{
    CoroutineCont cont(Coroutine::currentCoroutine());
    connect(sender, sig1, &cont, SLOT(cont()));
    connect(sender, sig2, &cont, SLOT(cont()));
    Coroutine::yield();
}

void CoroutineCont::yieldUntil(QObject *sender1, const char *sig1, QObject *sender2, const char *sig2)
{
    CoroutineCont cont(Coroutine::currentCoroutine());
    connect(sender1, sig1, &cont, SLOT(cont()));
    connect(sender2, sig2, &cont, SLOT(cont()));
    Coroutine::yield();
}

