// Copyright (C) March 2023-2024 Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
/* Companion code for local-variables.exp.  */
#include <omp.h>
#include <stdio.h>
#include <stdlib.h>

void
collatz_orbit()
{
  int i = 0, l = 0;
  #pragma omp parallel for private(i) lastprivate(l) num_threads(4)
  for (i = 2; i < 6; ++i)
    {
      int n = i;
      while (n != 1)
	{
          n = n % 2 ? (n*3)+1 : n / 2;
	}
      printf("Reached %d.\n", n); // post-collatz
      l = i;
    }
    printf("Last %d.\n", l); // post-parallel-for
}

int
main (int argc, char *argv[])
{
  int nthreads, tid, x;
  x = 40;
  #pragma omp parallel private(tid) firstprivate(x) shared(nthreads) num_threads(4)
    {
      tid = omp_get_thread_num();
      x = x + tid;
      printf("Thread = %d (x = %d)\n", tid, x);

      if (tid == 0)
	{
	  nthreads = omp_get_num_threads();
	  printf("Number of threads = %d\n", nthreads);
	}

      #pragma omp barrier
      printf("post barrier tag 1 = %d\n", x); // post-barrier-marker
      printf("post barrier tag 2 = %d\n", x); // post-barrier-backstop
    }

  collatz_orbit();

  return 0;
}
