include common.makefile

COMPILER_REPORTS_SUPPORTED := $(shell echo 'int main() { return 0; }' | $(CC) -E $(COMPILER_REPORT_FLAG) -xc - 2>/dev/null && echo yes)

vectorization: vectorization.c
ifeq ($(lastword $(COMPILER_REPORTS_SUPPORTED)),yes)
	$(CC) $(MAP_CFLAGS) -o $@ $< $(COMPILER_REPORT_FLAG)
else
	@echo Skipping compilation of 'vectorization' example - $(CC) does not support compiler reports
endif

.PHONY: clean
clean:
	$(RM) vectorization vectorization.c.opt-record.json.gz vectorization.opt.yaml
