#define WORKED_EXAMPLE_NOTICE "-------------------------------------------------------------------\n"\
                              "This program is designed to demonstrate MAP's compiler remarks\n"\
                              "feature. See the 'Worked Examples' section of the Linaro Forge\n"\
                              "user guide for more information:\n"\
                              "https://docs.linaroforge.com/latest/html/forge/index.html or\n"\
                              "../doc/userguide-forge.pdf\n"\
                              "-------------------------------------------------------------------\n"

#include <stdio.h>
#include <stdlib.h>

void triple(float *arr1, float *arr2, int num)
{
    // Loop array-bounds
    for (int i = 0; i < num; i++)
    {
        arr2[i] = 3.0f * arr1[i/2];
    }
}

int main()
{
    printf(WORKED_EXAMPLE_NOTICE);

    const int rows = 1000;
    const int cols = 1000;
    const int size = rows * cols;
    float *x = (float*)malloc(size*sizeof(float));
    float *y = (float*)malloc(size*sizeof(float));
    float *z = (float*)malloc(size*sizeof(float));

    for (int iter = 0; iter < 10000; iter++)
    {
        // Loop interchange
        for (int i = 0; i < rows; i++)
        {
            for (int j = 0; j < cols; j++)
            {
                z[j * cols + i] = x[j * cols + i] - y[j * cols + i];
            }
        }

        // Loop distribution
        for (int i = 1; i < size; i++)
        {
            x[i] = x[i - 1] * y[i - 1] - z[i];
            y[i] = 2.0f * y[i - 1];

            z[i] = x[i] + y[i];
        }

        triple(x, y, size);
    }

    free(x);
    free(y);
    free(z);
    return 0;
}
