/* Modified by Linaro.
   Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.
   
   Modified by Arm.
   Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.
   
   Copyright 2012 Free Software Foundation, Inc.
 *
 * Contributed by Intel Corp. <markus.t.metzger@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http:*www.gnu.org/licenses/>.
 *
 *
 * A series of races on a global variable by eight threads.
 */

static volatile int iterations = 10;
static volatile int shared;

static void
test (volatile int *var, int n)
{
#pragma omp parallel num_threads(8)
  {
    int i;

    for (i = 0; i < n; ++i)
      {
	*var = 42;
      }
  }
}

int main (void)
{
  test (&shared, iterations);

  return 0;
}
