// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
#include <stdio.h>

extern _Cilk_shared attach_gdb();

#define SIZE 16384

_Cilk_shared int arr1[SIZE];
_Cilk_shared int arr2[SIZE];
_Cilk_shared int arr3[SIZE];

_Cilk_shared void init_array()
{
  char buf[8];
  volatile int num_threads = 2;
  sprintf(buf, "%d", num_threads);

  volatile int superdummy = 0;
  int i;

  __cilkrts_set_param("nworkers", buf);

  _Cilk_for (i=0; i<SIZE; i++) {
    arr1[i] = i;
    arr2[i] = 1;
    arr3[i] = 2;
  }
  superdummy = -1; // just for bp
  superdummy = 0;
}

int main()
{
  _Cilk_offload attach_gdb();

  _Cilk_offload init_array();

  return 0;
}

