// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
#include <new>


extern "C" _Cilk_shared void attach_gdb();

class _Cilk_shared CELO4
{
  public:
    int    fieldi;
    double fieldd;
    float  fieldf;
    char   fieldc;
    short  fields;
    static int no_objs_count;
    bool   fieldummy;

    CELO4() {
      fieldi = 5;
      fieldd = 8888.0;
      fieldf = 9.0;
      fieldc = 'A';
      fields = 127;
      no_objs_count++;
      fieldummy = true;
    }

    ~CELO4() {
      fieldi = -45;
      fieldd = 29.0;
      fieldf = 42.0;
      fieldc = 'B';
      fields = 13;
      no_objs_count--;
      fieldummy = false;
    }
};

int CELO4::no_objs_count = 0;

_Cilk_shared CELO4 c4;
CELO4 _Cilk_shared *c4ptr;

_Cilk_shared int localclass()
{
  volatile int superdummy = 1;
  CELO4 c4_local;
  superdummy = 2;
  return c4_local.no_objs_count;
}

_Cilk_shared int checkpoint()
{
  volatile int checkdummy = 1;
  return checkdummy;
}

int main()
{
  _Cilk_offload attach_gdb();

  int num_objs = -1;

  c4ptr = new( _Offload_shared_malloc(sizeof(CELO4))) _Cilk_shared CELO4;

  num_objs = _Cilk_offload localclass();

    _Offload_shared_free(c4ptr);

  _Cilk_offload checkpoint();

  return 0;
}

