// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
_Cilk_shared int shared_var;

_Cilk_shared init(int val) {
    shared_var = val;
}

int main(int argc, char *argv[]) {
    // Initialize on target to not get ownership yet
    _Cilk_offload init(1);

    // Read the value on host: no ownership, ownership on target
    volatile int old_val = shared_var;

    volatile int bp1 = 1;       /* bp1 */

    // Write the value on host: ownership on host
    shared_var = 1;

    volatile int bp2 = 1;       /* bp2 */

    // Initialize on target again to remove ownership from host
    _Cilk_offload init(1311);

    volatile int bp3 = 1;       /* bp3 */

    return 0;
}
