! Copyright (C) March 2023-2025 Linaro Limited (or its affiliates). All rights reserved.

! 
! This program is free software: you can redistribute it and/or modify
! it under the terms of the GNU General Public License as published by
! the Free Software Foundation, either version 3 of the License, or
! (at your option) any later version.
! 
! This program is distributed in the hope that it will be useful,
! but WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! GNU General Public License for more details.
! 
program dynamic_pointer_properties
    implicit none
    type :: structure
        real(kind=8) :: a
        real(kind=8) :: b
        real(kind=8) :: c
    end type structure
    type array_of_structs
        integer(kind=4) :: length
        type(structure), dimension(:), allocatable :: array
    end type array_of_structs
    type(array_of_structs) :: space
    integer(kind=4) :: length
    length = 4
    call initialise_space(space, length)
    call export_space(space)
contains
    subroutine initialise_space(space, length)
        type(array_of_structs), intent(inout) :: space
        integer(kind=4) :: length
        allocate(space%array(length))
        space%length = length
        space%array(:)%a = 1.0
        space%array(:)%b = 2.0
        space%array(:)%c = 4.0
    end subroutine initialise_space
    subroutine export_space(space)
        type(array_of_structs), intent(inout) :: space
        type(array_of_structs), target :: local_space
        type(array_of_structs), pointer :: local_space_pointer
        type(structure), dimension(:), pointer :: structure_pointer
        integer(kind=4), target :: ispace
        integer(kind=4), target :: local_integer
        integer(kind=4), pointer :: local_integer_pointer
        allocate(local_space%array(2))
        local_space%length = 2
        local_space%array(:)%a = 1.0
        local_space%array(:)%b = 2.0
        local_space%array(:)%c = 4.0
        local_space_pointer => local_space
        structure_pointer => local_space%array
        local_integer = 2
        local_integer_pointer => local_integer
        do ispace=1,space%length
            print *, space%array(ispace)%a, space%array(ispace)%b,&
                     space%array(ispace)%c
        end do
        print *, space%length, local_space%length ! stop-here
        print *, local_integer_pointer, local_integer
    end subroutine export_space
end program dynamic_pointer_properties
