! Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

! Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

! 
! This program is free software: you can redistribute it and/or modify
! it under the terms of the GNU General Public License as published by
! the Free Software Foundation, either version 3 of the License, or
! (at your option) any later version.
! 
! This program is distributed in the hope that it will be useful,
! but WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! GNU General Public License for more details.
! 
! Arm Forge test case
! Companion source to sw-watchpoint-on-arrays-with-limited-print.exp
program main
    implicit none

    type t_face
      integer :: id_face
      integer :: adj_cell(4)
    end type t_face

    type t_poly
      integer      :: id_poly
      type(t_face) :: face(5)
    end type t_poly

    type t_brick_list
      integer                   :: id_t_brick_list
      type(t_poly), allocatable :: poly(:)
    end type t_brick_list

    integer          :: i, j, k, iface, icell
    integer, target  :: var1, var2, var3
    integer, pointer :: p_var
    type(t_brick_list) :: brick_list(10,10)

    do i=1,10
      do j=1,10
        allocate(brick_list(i,j)%poly(100))
        do k=1,100
          do iface=1,5
            do icell=1,4
              brick_list(i,j)%poly(k)%face(iface)%adj_cell(icell)=1
            end do
          end do
        end do
      end do
    end do
    do i=1,10
      do j=1,10
        do k=1,100
          var1=k
          do iface=1,5
            do icell=1,4 ! change_brick_list
              brick_list(i,j)%poly(k)%face(iface)%adj_cell(icell)=k
            end do
          end do
        end do
      end do
    end do
end program main
