/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "widercommandlinkbutton.h"

WiderCommandLinkButton::WiderCommandLinkButton ( QWidget * parent ) : 
    QCommandLinkButton(parent)
{
    fixFontSize();
}
WiderCommandLinkButton::WiderCommandLinkButton ( const QString & text, QWidget * parent ) :
    QCommandLinkButton(text, parent)
{
    fixFontSize();
}
WiderCommandLinkButton::WiderCommandLinkButton ( const QString & text, const QString & description, QWidget * parent ) :
    QCommandLinkButton(text, description, parent)
{
    fixFontSize();
}

//! Workaround for #28951 - command link button font size too small.
/*!
 * If a font is not explicitly set on a QCommandLinkButton then it uses fixed point sizes for the title
 * and description fonts which do no scale with the rest of the application. When explicitly setting the font
 * QCommandLinkButton does not use the fixed point sizes so the button scales as we would like.
 */
void WiderCommandLinkButton::fixFontSize()
{
    QFont f(font());
    f.setPointSize(f.pointSize());
    setFont(f);
}

/*! \reimp */
QSize WiderCommandLinkButton::sizeHint() const
{
    QSize size(QCommandLinkButton::sizeHint());
    if (description().isEmpty())
        return size;
    QFontMetrics fm(font());
    int textWidth = fm.horizontalAdvance(description());
    int leftMargin = 7;
    int rightMargin = 4;
    int textOffset = icon().actualSize(iconSize()).width() + leftMargin + 6;
    int descriptionWidth = textWidth + textOffset + rightMargin;
    return QSize(qMax(descriptionWidth, size.width()), size.height());
}
