/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

/* Header file to precompile.
 * When this file is set as the PRECOMPILED_HEADER file in texteditor.pro
 * it will be automatically be compiled then included in every other 
 * compile done by that project.
 *
 * Do not #include this file directly.
 *
 * Do not #include any headers in the file if they are subject to change. 
 * A change to this file (or any file #included in this file) will force
 * the header to be precompiled again, then all object files in the project
 * will need to be recompiled. */ 

/* Add C includes here */

#if defined __cplusplus
// Add C++ includes here

// Include all headers that occur more than a couple of times, listed in
// order of increasing frequency.  Obtained by command:

// grep -h "#include" * | sort -d | uniq --count | sort -n | awk '{if($1>9) print $2, $3}'

// This is only a rough guess of frequency of course - a header that is 
// listed once in a frequently used header file will not have its true 
// usage represented here.

// Non-Qt headers have been commented out. Any changes would require a 
// recompilation of this file, and thus the entire project. We might want 
// to include some of our unlikely-to-be-modified-much headers later.

// NB: Only looked at frontend directory here, if we start including
// DDT header files, be sure to check /network, /lgpl and /common for 
// candidates as well.

#include <QApplication>
#include <QLatin1String>
#include <QMap>
#include <QWidget>
#include <QCoreApplication>
#include <QTextBlock>
#include <QTextCodec>
#include <QTextDocument>
#include <QDir>
#include <QPainter>
#include <QFile>
#include <QSharedPointer>
#include <QFileInfo>
#include <QTextCursor>
#include <QObject>
#include <QList>
#include <QSettings>
#include <QStringList>
#include <QDebug>
#include <QString>

#endif // _cplusplus
