/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "multiindexabstractitemdelegate.h"

MultiIndexAbstractItemDelegate::MultiIndexAbstractItemDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

QString
MultiIndexAbstractItemDelegate::multipleIndexTooltipText(const QList<QModelIndex> &indexes) const
{
    if (indexes.isEmpty())
        return QString{};
    else
        return indexToolTipText(indexes.at(0));
}

QString
MultiIndexAbstractItemDelegate::indexToolTipText(const QModelIndex &index) const
{
    if (index.isValid())
        return index.data(Qt::ToolTipRole).toString();
    else
        return QString{};
}
