/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef TERMINALWINDOW_H
#define TERMINALWINDOW_H

#include <QDialog>
#include "lgpl_gui_export.h"

class Terminal;
class TerminalWidget;
class LGPL_GUI_EXPORT TerminalWindow : public QDialog
{
    Q_OBJECT
public:
    explicit TerminalWindow(Terminal *terminal, QWidget *parent = 0);
    explicit TerminalWindow(QWidget *parent = 0);
    Terminal *terminal() const;
    void setTerminal(Terminal *terminal);
private slots:
    void processFinished();
private:
    void init();

    TerminalWidget *mTerminalWidget;
};

#endif // TERMINALWINDOW_H
