/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef TERMINALPROCESS_H
#define TERMINALPROCESS_H

#include <QProcess>
#include "lgpl_gui_export.h"

class Terminal;
class LGPL_GUI_EXPORT TerminalProcess : public QProcess
{
    Q_OBJECT
public:
    explicit TerminalProcess(Terminal *terminal, QObject *parent = 0);
    virtual ~TerminalProcess();
    Terminal *terminal() const;
    void start(const QString& program, const QStringList& arguments, OpenMode mode = ReadWrite);
    void startScript(const QString& script, const QStringList& arguments, const OpenMode mode = ReadWrite);

protected:
#ifndef Q_OS_WIN
    virtual void modifyChildProcess();
#endif

private slots:
    void processFinished(int exitCode, QProcess::ExitStatus exitStatus);
private:
    Terminal *mTerminal;
#ifndef Q_OS_WIN
#if QT_VERSION < QT_VERSION_CHECK(6,0,0)
    virtual void setupChildProcess() override;
#endif
#endif
};

#endif // TERMINALPROCESS_H
