/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2011-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 */

#include <QDrag>
#include <QScrollBar>
#include "fixedheightlistwidget.h"

FixedHeightListWidget::FixedHeightListWidget(QWidget *parent) :
    QListWidget(parent)
{
}

QSize FixedHeightListWidget::minimumSizeHint() const
{
    QSize sz = QListWidget::minimumSizeHint();
    if (flow() == LeftToRight) {
        int height = 1;
        for (int i=0;i<count();++i)
            height = qMax(height, sizeHintForIndex(model()->index(i, 0)).height());
        QWidget *scrollAreaContainer = findChild<QWidget *>(QLatin1String("qt_scrollarea_hcontainer"));
        if (scrollAreaContainer)
            height += scrollAreaContainer->minimumSizeHint().height();
        height += horizontalScrollBar()->minimumSizeHint().height();
        QStyleOption opt;
        opt.initFrom(this);
        if ((frameStyle() != QFrame::NoFrame)
            && style()->styleHint(QStyle::SH_ScrollView_FrameOnlyAroundContents, &opt, this)) {
            height += style()->pixelMetric(QStyle::PM_ScrollView_ScrollBarSpacing, &opt, this);
        }
        height += 2 * frameWidth();
        ++height;
        sz.setHeight(height);
    } else {
        int width = 1;
        for (int i=0;i<count();++i)
            width = qMax(width, sizeHintForIndex(model()->index(i, 0)).width());
        QWidget *scrollAreaContainer = findChild<QWidget *>(QLatin1String("qt_scrollarea_vcontainer"));
        if (scrollAreaContainer)
            width += scrollAreaContainer->minimumSizeHint().width();
        width += horizontalScrollBar()->minimumSizeHint().width();
        QStyleOption opt;
        opt.initFrom(this);
        if ((frameStyle() != QFrame::NoFrame)
            && style()->styleHint(QStyle::SH_ScrollView_FrameOnlyAroundContents, &opt, this)) {
            width += style()->pixelMetric(QStyle::PM_ScrollView_ScrollBarSpacing, &opt, this);
        }
        width += 2 * frameWidth();
        ++width;
        sz.setWidth(width);
    }
    return sz;
}

QSize FixedHeightListWidget::sizeHint() const
{
    return minimumSizeHint();
}
