/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef DETAILSWIDGET_P_H
#define DETAILSWIDGET_P_H

inline int mix(int v1, int v2, int a)
{
    return v1 * a / 255 + v2 * (255 - a) / 255;
}

inline QColor mix(const QColor &colour, const QColor& bg)
{
    return QColor(mix(colour.red(), bg.red(), colour.alpha()),
                  mix(colour.green(), bg.green(), colour.alpha()),
                  mix(colour.blue(), bg.blue(), colour.alpha()));
}

#endif // DETAILSWIDGET_P_H
