/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (info@qt.nokia.com)
**
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** Other Usage
**
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
** If you have questions regarding the use of this file, please contact
** Nokia at info@qt.nokia.com.
**
**************************************************************************/

#ifndef DETAILSWIDGET_H
#define DETAILSWIDGET_H

#include "lgpl_gui_export.h"
#include <QWidget>

class DetailsWidgetPrivate;
class FadingPanel;

class LGPL_GUI_EXPORT DetailsWidget : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(QString summaryText READ summaryText WRITE setSummaryText DESIGNABLE true)
    Q_PROPERTY(QString additionalSummaryText READ additionalSummaryText WRITE setAdditionalSummaryText DESIGNABLE true)
    Q_PROPERTY(bool useCheckBox READ useCheckBox WRITE setUseCheckBox DESIGNABLE true)
    Q_PROPERTY(bool checked READ isChecked WRITE setChecked DESIGNABLE true)
    Q_PROPERTY(State state READ state WRITE setState)
    Q_ENUMS(State)

public:
    enum State {
        Expanded,
        Collapsed,
        NoSummary
    };

    explicit DetailsWidget(QWidget *parent = 0);
    virtual ~DetailsWidget();

    void setSummaryText(const QString &text);
    QString summaryText() const;

    void setAdditionalSummaryText(const QString &text);
    QString additionalSummaryText() const;

    void setState(State state);
    State state() const;

    void setWidget(QWidget *widget, int margin=-1);
    QWidget *widget() const;

    void setToolWidget(QWidget *widget);
    QWidget *toolWidget() const;

    void setSummaryFontBold(bool b);

    bool isChecked() const;

    bool useCheckBox();
    void setUseCheckBox(bool b);
    void setCheckBoxEnabled(bool b);
    bool checkBoxEnabled() const;
    /// Sets an icon, only supported if useCheckBox is true
    void setIcon(const QIcon &icon);

    void setDetailButtonVisible(bool b);
    bool detailButtonVisible() const;

    void setDetailButtonEnabled(bool b);
    bool detailButtonEnabled() const;

    void setDetailButtonText(const QString& text);
    void setDetailButtonText(const QString& expandText,
                             const QString& collapseText);
    void setSummaryToolTip(const QString& tip);

    void setToggleDetailsOnSummaryBarClicks(bool b);
    bool toggleDetailsOnSummaryBarClicks() const;

public slots:
    void setChecked(bool b);

signals:
    void checked(bool);
    void expanded(bool);
    void linkActivated(const QString &link);
    void detailsClicked();

private slots:
    void setExpanded(bool);
    void summaryCheckBoxToggled(bool);
    void on_labelBackgroundClicked();

protected:
    virtual void paintEvent(QPaintEvent *paintEvent) override;
#if QT_VERSION < QT_VERSION_CHECK(6,0,0)
    virtual void enterEvent(QEvent *event) override;
#else
    virtual void enterEvent(QEnterEvent *event) override;
#endif
    virtual void leaveEvent(QEvent *event) override;

private:
    virtual bool eventFilter(QObject *, QEvent *) override;

    DetailsWidgetPrivate *d;
};

#endif // DETAILSWIDGET_H
