/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef COROUTINEMUTEX_H
#define COROUTINEMUTEX_H

#include <QList>
#include "coroutinewaitcondition.h"

#include "lgpl_core_export.h"

class LGPL_CORE_EXPORT CoroutineMutex : private CoroutineWaitCondition
{
public:
    CoroutineMutex();
    ~CoroutineMutex();
    void lock();
    void unlock();
    Coroutine *remoteUnlock();
    Coroutine *holder() const;
private:
    void commonUnlock();

    Coroutine *mHolder;
};

#endif // COROUTINEMUTEX_H
