/**************************************************************************
**
** This file is part of the Coroutine library
**
** Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://qt.nokia.com/contact.
**
**************************************************************************/

#ifndef INCLUDE_COROUTINE_H
#define INCLUDE_COROUTINE_H

#include <QObject>
#include "lgpl_core_export.h"

class LGPL_CORE_EXPORT Coroutine : public QObject
{
    Q_OBJECT
public:
    enum { DefaultStackSize = 1024 * 1024 };

    enum Status
    {
        NotStarted,
        Running,
        Stopped,
        Terminated
    };

public:
    Coroutine(QObject *parent = 0);
    virtual ~Coroutine();

    void createStack(int size = DefaultStackSize);
    void setStack(void *memory, int size);
    void setAutoDelete(bool autoDelete);
    bool autoDelete() const
    { return _autoDelete; }
    
    static void yield();
    
    Status status() const
    { return _status; }

    bool isRootCoroutine() const;

    void stackInfo(void **data, size_t *size, void **base, void **current) const;

    static Coroutine *currentCoroutine();

#ifdef qdoc
    static Coroutine *build(Function function, ...);
#endif
// add declarations for static build(...) function
#include "coroutinebuilddeclaration_p.h"

public slots:
    bool cont();

protected:
    virtual void run() {}

private: // not copyable
    Coroutine(const Coroutine &);
    Coroutine &operator=(const Coroutine &);

private:
    static void yieldHelper(Status stopStatus);
    static void entryPoint();
    void freeStack();
#ifdef Q_OS_WIN
    void initializeStackLimits();
#endif

    void *_stackData;
    size_t _stackSize;
    void *_stackBase;
    void *_stackPointer;
#ifdef Q_OS_WIN
    void *_fiber;
#endif
    Coroutine *_caller;
    Status _status;
#ifdef Q_OS_WIN
    //! Is this the main fiber (the one we converted with ConvertThreadToFiber)?
    /*!
     * We don't want to delete the main fiber as this exits the program.
     */
    bool _mainFiber;
#endif
    bool _autoDelete;
    bool _ownStack;
};

// add definitions for static build(...) function
#include "coroutinebuilddefinition_p.h"

#endif // INCLUDE_COROUTINE_H
