/**************************************************************************
**
** This file is part of the Coroutine library
**
** Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://qt.nokia.com/contact.
**
**************************************************************************/

#include <stdlib.h>

// On PowerPC entry is a pointer to the function descriptor, not the entry point of the function.
void initializeStack(void *data, int size, void (*entry)(), void **stackBase, void **stackPointer)
{
    void* stackBottom = (char*)data + size;
    // align to 16 byte
    stackBottom = (void*)((size_t)stackBottom & ~0xF);
    *stackBase = stackBottom;

    void **p = (void**)stackBottom;
    *stackPointer = p;

    *(--p) = ((void **)entry)[1]; // TOC (r2)
    *(--p) = ((void **)entry)[2]; // environment pointer (r11)
    for (int i=0;i<18;++i)
        *(--p) = 0;
    void *cr = 0;
    __asm__ ("mfcr %0" 
             : "=r"(cr));
    *(--p) = cr;
    *(--p) = ((void **)entry)[0]; // lr 
}

