# SPDX-FileCopyrightText: Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved. Copyright (C) 2023 Arm Limited and/or its affiliates.
#
# -*- coding: iso-8859-1 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import print_function
import gdb

class ForgeInfoDataAddress (gdb.Command):
    """
    Language independent mechanism for printing the address of variable.

    info data-address <identifier>
    """
    def __init__ (self):
      super (ForgeInfoDataAddress, self).__init__ ("info data-address", gdb.COMMAND_USER)

    def invoke (self, arg, from_tty):
      try:
          value = gdb.parse_and_eval(arg)
          address = value.address
          address = "Value not in memory." if not address else address
          print (str(address))
      except gdb.error as error:
          print (str(error))

ForgeInfoDataAddress ()
