#!/bin/sh

cd "`dirname "$0"`"

if test -n "$LOGNAME"; then
    # This can fail when installing on NFS, but a working forge install
    # would've been created
    chown -R "$LOGNAME" . > /dev/null 2>&1
fi

OLD_BIN_FILES="assistant cpp_scanner cpp_vargrabber ctags cuda-gdb cuda-gdb-31 cuda-gdb-32 forge.bin forge-treeserver execsubmit f90_scanner f90_vargrabber f_scanner f_vargrabber gdb gdb.32 gdb.64 grab_c grab_f grab_f90 installer installer-stub llrun pbsrun remote-exec remote-exec.rsh remote-exec.ssh scan_c scan_f scan_f90 xdg-desktop-menu xdg-icon-resource xdg-open"
OLD_LIBEXEC_FILES="cuda-gdb-31 remote-exec.ssh remote-exec.rsh"
BACKUP_FOLDER="cleanup/`date +%Y-%m-%d-%T`"

for i in $OLD_BIN_FILES
do
	if test -e "bin/$i" -o -h "bin/$i"; then
		[ -d "$BACKUP_FOLDER" ] || mkdir -p "$BACKUP_FOLDER"
		
		mv "bin/$i" "$BACKUP_FOLDER/"
	fi
done

for i in $OLD_LIBEXEC_FILES
do
	if test -e "libexec/$i" -o -h "libexec/$i"; then
		[ -d "$BACKUP_FOLDER" ] || mkdir -p "$BACKUP_FOLDER"
		
		mv "libexec/$i" "$BACKUP_FOLDER/"
	fi
done

# In release 4.2, some old makefiles for the examples were merged into a single new makefile 
OBSOLETE_EXAMPLE_MAKEFILES="cmake.makefile fmake.makefile f90make.makefile"

for i in $OBSOLETE_EXAMPLE_MAKEFILES
do
    [ -f "examples/$i" ] && rm "examples/$i"
done

# Remove installer from installation
rm -f libexec/installer

