import ctypes
import os

__all__ = ['allinea_start_sampling', 'allinea_stop_sampling']

mapsampler_handle = None

def mapsampler_lib():
    # Forge sampler should already be loaded, so this will simply return a reference to it
    global mapsampler_handle
    if mapsampler_handle is None:
        script_path = os.path.dirname(os.path.realpath(__file__))
        mapsampler_path = os.path.join(script_path, '../../lib/64/libmap-sampler.so')
        mapsampler_handle = ctypes.CDLL(mapsampler_path)

    return mapsampler_handle

def allinea_start_sampling():
    mapsampler_lib().allinea_start_sampling()

def allinea_stop_sampling():
    mapsampler_lib().allinea_stop_sampling()
