#include <time.h>

/*
 * This library is used in the python-profiling.py example.
 * See python-profiling.py for more details.
 */
unsigned long long compute_logistic_map(const double r,
                                        double x,
                                        const unsigned int timeSeconds) {
    struct timespec start, now;
    clock_gettime(CLOCK_REALTIME, &start);

    double elapsed = 0.0;
    unsigned long long iterations=0;
    do {
        int p=0;
        for (p=0; p<30; ++p) {
            x = r*x*(1.0-x);
            iterations += 1;
        }
        clock_gettime(CLOCK_REALTIME, &now);
        elapsed = (double)now.tv_sec + (now.tv_nsec/1000000000.0)
                - (double)start.tv_sec + (start.tv_nsec/1000000000.0);
    } while (elapsed < timeSeconds);

    return iterations;
}
