/***************************************************************************
 *   Copyright (C) 2006 by Helio Chissini de Castro   *
 *   helio@mandriva.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include "askpassqt.h"

#include <QProcess>
#include <QCoreApplication>
#include <QFile>
#include <QFileInfo>
#include <QMessageBox>

AskPassQt::AskPassQt( const QString& prompt, QWidget* parent )
	: QDialog(parent), status( 1 )
{
    setupUi(this);

    if (!prompt.isNull())
    {
        tlText->setText(prompt);

        if(prompt.contains(_("yes/no"))) // Likely a yes/no question, so don't obscure "password"
        {
            lePasswd->setEchoMode(QLineEdit::Normal);
        }
    }
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void AskPassQt::changeEvent(QEvent *event)
{
    if (event->type() == QEvent::LanguageChange)
    {
        retranslateUi(this);
    }

    QDialog::changeEvent(event);
}

void AskPassQt::okSlot()
{
    puts( qPrintable(lePasswd->text()) );
    status = 0;
    close();
}

void AskPassQt::on_buttons_helpRequested()
{
    QMessageBox::information(this, tr("Help"), tr("This window shows prompts from OpenSSH when connecting to a remote system."), QMessageBox::Ok);
}

void AskPassQt::quitWithStatus()
{
    exit(status);
}
