# Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

# Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
#
#  Awk program to analyze mtrace.c output.
#
$1 == "+"	{ if (allocated[$2] != "")
		    print "+", $2, "Alloc", NR, "duplicate:", allocated[$2];
		  else
		    allocated[$2] = $3;
		}
$1 == "-"	{ if (allocated[$2] != "") {
		    allocated[$2] = "";
		    if (allocated[$2] != "")
			print "DELETE FAILED", $2, allocated[$2];
		  } else
		    print "-", $2, "Free", NR, "was never alloc'd";
		}
$1 == "<"	{ if (allocated[$2] != "")
		    allocated[$2] = "";
		  else
		    print "-", $2, "Realloc", NR, "was never alloc'd";
		}
$1 == ">"	{ if (allocated[$2] != "")
		    print "+", $2, "Realloc", NR, "duplicate:", allocated[$2];
		  else
		    allocated[$2] = $3;
		}

# Ignore "= Start"
$1 == "="	{ }
# Ignore failed realloc attempts for now
$1 == "!"	{ }


END		{ for (x in allocated) 
		    if (allocated[x] != "")
		      print "+", x, allocated[x];
		}
