// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
#include <stdio.h>

extern _Cilk_shared myo_attach_gdb();

_Cilk_shared float my_shared;

_Cilk_shared foo(float val)
{
    volatile float old_val = my_shared; /* force reading the current value on MIC. */
    my_shared += val;                   /* here my_shared MUST be evaluated correctly. */
    old_val = val;                      /* BP1 */
}

int main()
{
    _Cilk_offload myo_attach_gdb();

    my_shared = 1.0f;
    float my_copy = 0.0f;
    int tot_loops = 100;
    int i = 0;

    for(i=0; i<tot_loops; i++) {
        my_copy = my_shared;            /* force the proper value on host, */
        my_copy += 1.0f;                /* using two lines to avoid bp on shared function call. */
        _Cilk_offload foo(2.0f);        /* here my_shared MUST be evaluated correctly, */
        my_shared += 1.0f;              /* using two lines for easier bp handling. */
    }

    return 0;
}

