// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
extern _Cilk_shared myo_attach_gdb();

_Cilk_shared param_int(int val) {
    volatile int local_val = val;   /* int1 */
    local_val++;
    val = local_val;
}

_Cilk_shared param_double(double val) {
    volatile double local_val = val;   /* double1 */
    local_val++;
    val = local_val;
}

_Cilk_shared param_float(float val) {
    volatile float local_val = val;   /* float1 */
    local_val++;
    val = local_val;
}


int main(int argc, char* argv[]) {
    _Cilk_offload myo_attach_gdb();

    volatile int intp = 42;
    volatile double doublep = 42.42;
    volatile float floatp = 42.424242f;

    _Cilk_offload param_int(intp);
    _Cilk_offload param_double(doublep);
    _Cilk_offload param_float(floatp);

    return 0;
}
