// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
#include <stdlib.h>
#include <omp.h>

extern _Cilk_shared myo_attach_gdb();

_Cilk_shared int total = 0;

_Cilk_shared void msample04()
{
    int num_threads = 128;
    volatile int loop = 1;

    volatile int bp = 0;
    while (loop)
    {
        total = 42; // don't start from 0,
                    // better avoid nasty
                    // surprises with
                    // _Cilk_shared vars

        omp_set_num_threads(num_threads);
        bp = 1;         /* before_omp_loop */
        int i;
        #pragma omp parallel for
        for(i=0; i<1048576; i++)
        {
            bp = 2;     /* omp_loop_bp1 */
            total++;
            bp = 3;     /* omp_loop_bp2 */
        }
    }

    bp = 0;
}

int main()
{
    _Cilk_offload myo_attach_gdb();
    _Cilk_offload msample04();
    return 0;
}
