// Copyright (C) March 2023- Linaro Limited (or its affiliates). All rights reserved.

// Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.

// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
#include <stdio.h>
#include <unistd.h>

extern _Cilk_shared myo_attach_gdb();

#define SIZE 16384

_Cilk_shared int arr[SIZE];

_Cilk_shared void delay_trick()
{
    sleep(2);
}

_Cilk_shared void init_array()
{
    volatile int use_delay_trick = 0;
    int i;
    _Cilk_for (i=0; i<SIZE; i++)
    {
        arr[i] = i;             /* before_delay_trick */
        if(use_delay_trick) {   /* if_use_delay_trick */
            delay_trick();
        }
    }
    use_delay_trick = -1; // just for bp
    use_delay_trick = 0;        /* delay_trick_set_0 */
}

int main()
{
    _Cilk_offload myo_attach_gdb();
    _Cilk_offload init_array();

    return 0;
}

