/* This testcase is part of GDB, the GNU debugger.

   Modified by Linaro.
   Copyright (C) March 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
   
   Modified by Arm.
   Copyright (C) 1995-2023 Arm Limited (or its affiliates). All rights reserved.
   
   Copyright (C) 2023-2025 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <stdio.h>

int
main ()
{
  const size_t ARRAY_SIZE_BYTES = 10000000;
  const size_t ARRAY_LENGTH = ARRAY_SIZE_BYTES/sizeof(int);

  int *large_1d_array = (int *) malloc(ARRAY_SIZE_BYTES);

  size_t i;
  for (i = 0; i < ARRAY_LENGTH; i++)
  {
    large_1d_array[i] = 1;
  }

  printf("initiated!\n");  /* break_here */

  free(large_1d_array);

  return 0;
}
