/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2012 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** Other Usage
**
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#ifndef HIGHLIGHTDEFINITIONHANDLER_H
#define HIGHLIGHTDEFINITIONHANDLER_H

#include <QString>
#include <QList>
#include <QSharedPointer>
#include <QStack>
#include <QXmlStreamAttributes>

namespace TextEditor {
namespace Internal {

class KeywordList;
class Context;
class Rule;
class HighlightDefinition;

// previously derived from QXmlDefaultHandler
class HighlightDefinitionHandler
{
public:
    HighlightDefinitionHandler(const QSharedPointer<HighlightDefinition> &definition);
    ~HighlightDefinitionHandler();
    bool parse(QIODevice *device);

private: // previously public QXmlDefaultHandler overrides
    bool startDocument();
    bool endDocument();
    bool startElement(const QString &namespaceURI, const QString &localName,
                      const QString &qName, const QXmlStreamAttributes &atts);
    bool endElement(const QString &namespaceURI, const QString &localName, const QString &qName);
    bool characters(const QString &ch);

private:
    void listElementStarted(const QXmlStreamAttributes &atts);
    void itemElementStarted();
    void contextElementStarted(const QXmlStreamAttributes &atts);
    void itemDataElementStarted(const QXmlStreamAttributes &atts) const;
    void commentElementStarted(const QXmlStreamAttributes &atts) const;
    void keywordsElementStarted(const QXmlStreamAttributes &atts) const;
    void foldingElementStarted(const QXmlStreamAttributes &atts) const;
    void ruleElementStarted(const QXmlStreamAttributes &atts, const QSharedPointer<Rule> &rule);

    // Specific rules.
    void detectCharStarted(const QXmlStreamAttributes &atts);
    void detect2CharsStarted(const QXmlStreamAttributes &atts);
    void anyCharStarted(const QXmlStreamAttributes &atts);
    void stringDetectedStarted(const QXmlStreamAttributes &atts);
    void regExprStarted(const QXmlStreamAttributes &atts);
    void keywordStarted(const QXmlStreamAttributes &atts);
    void intStarted(const QXmlStreamAttributes &atts);
    void floatStarted(const QXmlStreamAttributes &atts);
    void hlCOctStarted(const QXmlStreamAttributes &atts);
    void hlCHexStarted(const QXmlStreamAttributes &atts);
    void hlCStringCharStarted(const QXmlStreamAttributes &atts);
    void hlCCharStarted(const QXmlStreamAttributes &atts);
    void rangeDetectStarted(const QXmlStreamAttributes &atts);
    void lineContinue(const QXmlStreamAttributes &atts);
    void includeRulesStarted(const QXmlStreamAttributes &atts);
    void detectSpacesStarted(const QXmlStreamAttributes &atts);
    void detectIdentifier(const QXmlStreamAttributes &atts);

    void processIncludeRules() const;
    void processIncludeRules(const QSharedPointer<Context> &context) const;

    QSharedPointer<HighlightDefinition> m_definition;

    bool m_processingKeyword;
    QString m_currentKeyword;
    QSharedPointer<KeywordList> m_currentList;
    QSharedPointer<Context> m_currentContext;
    QStack<QSharedPointer<Rule> > m_currentRule;

    bool m_initialContext;
};

} // namespace Internal
} // namespace TextEditor

#endif // HIGHLIGHTDEFINITIONHANDLER_H
