/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef FINDSYSTEM_H
#define FINDSYSTEM_H

#include "texteditor_global.h"
#include <QObject>

namespace Find {
namespace Internal {
class FindToolBar;
class CurrentDocumentFind;
} // end namespace Internal
} // end namespace Find


namespace TextEditor {

class TEXTEDITOR_EXPORT FindSystem : public QObject
{
    Q_OBJECT
public:
    static FindSystem* instance();
    
signals:
    
public slots:
    void openFindToolBar(bool focus=true);
    void openFindToolBar(QString &initialText, bool focus=true);
    void openFindToolBarInDirection(bool backwards=false);
    void closeFindToolBar();

    void setUseFakeVim(bool on);

    void findNext();
    void findPrevious();
    void find(bool reverse);

    void setCaseSensitive(bool);

    QWidget * findToolBarWidget();


private:
    explicit FindSystem();
    void init();

    Find::Internal::FindToolBar         *m_findToolBarInstance;
    Find::Internal::CurrentDocumentFind *m_currentDocumentFind;

    static FindSystem *static_instance;
};

} // end namespace TextEditor

#endif // FINDSYSTEM_H
