/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <QVBoxLayout>
#include "terminal.h"
#include "terminalwindow.h"
#include "terminalwidget.h"

TerminalWindow::TerminalWindow(Terminal *terminal, QWidget *parent) :
    QDialog(parent)
{
    init();
    setTerminal(terminal);
}

TerminalWindow::TerminalWindow(QWidget *parent) :
    QDialog(parent)
{
    init();
}

void TerminalWindow::init()
{
    mTerminalWidget = new TerminalWidget(this);
    QVBoxLayout *vboxLayout = new QVBoxLayout(this);
    vboxLayout->setContentsMargins(0, 0, 0, 0);
    vboxLayout->addWidget(mTerminalWidget);
    vboxLayout->setSizeConstraint(QLayout::SetFixedSize);
}

void TerminalWindow::processFinished()
{
    setWindowTitle(windowTitle() + QLatin1Char(' ') + tr("[finished]"));
}

void TerminalWindow::setTerminal(Terminal *terminal)
{
    mTerminalWidget->setTerminal(terminal);
    if (terminal) {
        connect(terminal, &Terminal::processStarted, this, &TerminalWindow::setWindowTitle);
        connect(terminal, &Terminal::processFinished, this, &TerminalWindow::processFinished);
    }
}

Terminal *TerminalWindow::terminal() const
{
    return mTerminalWidget->terminal();
}
