/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include "terminal.h"

Terminal::Terminal(QObject *parent) :
    QIODevice(parent),
    mCurrentProcess(0),
    mColumns(80),
    mRows(12)
{
}

Terminal::~Terminal()
{
}

void Terminal::winch()
{
}

qint64 Terminal::writeData(const char *data, qint64 len)
{
    if (mCurrentProcess)
        return mCurrentProcess->write(data, len);
    else
        return 0;
}

bool Terminal::openManager()
{
	return open(QIODevice::ReadWrite);
}
