/****************************************************************************
**
** Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
** Copyright (C) 2013-2023 Arm Limited (or its affiliates).
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**********************************************************************/
#ifndef QPIPEWRITER_P_H
#define QPIPEWRITER_P_H

#include "qpipewriter.h"
#include "qringbuffer_p.h"
#include <functional>

class QSocketNotifier;
class QTimer;

class QPipeWriterPrivate
{
    Q_DECLARE_PUBLIC(QPipeWriter)
public:
    QPipeWriterPrivate();
    ~QPipeWriterPrivate();

    // private slots
    bool _q_canWrite();
    void _q_tryOpen();

    qint64 write(const char* data, qint64 maxlen);
    qint64 bytesAvailable() const;
    void setPipeDescriptor(Q_PIPE pipe);
    void close();
    void startTimer();

    QObject* q_ptr;

    DDTRingBuffer buffer;
    QSocketNotifier* notifier;
    QByteArray nativeFilename;
    QTimer* openTimer;
    QFile* logFile;
    std::function<QByteArray()> timestampFn;
    int openTries;
    Q_PIPE pipe;
    bool eof;
    //! Should the pipe be closed when the buffer is emptied?
    /*! A caller may call close but the buffer is not empty.
        In this case the buffer needs to be fully written first before closing. */
    bool closeWhenBufferEmpty;
private:
    void closePipe();
    void createNotifier();
};

#endif  // !QPIPEWRITER_P_H
