/****************************************************************************
**
** Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
** Copyright (C) 2009-2023 Arm Limited (or its affiliates).
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**********************************************************************/

#ifndef QPIPEWRITER_H
#define QPIPEWRITER_H

#include "lgpl_core_export.h"

#include <QIODevice>
#include <QFile>
#include <functional>

#ifdef Q_OS_WIN
#include "QtCore/qt_windows.h"
typedef HANDLE Q_PIPE;
#define INVALID_Q_PIPE INVALID_HANDLE_VALUE
#else
typedef int Q_PIPE;
#define INVALID_Q_PIPE -1
#endif

class QPipeWriterPrivate;
class LGPL_CORE_EXPORT QPipeWriter : public QIODevice
{
    Q_OBJECT
public:
    QPipeWriter( QObject *parent = 0 );
    ~QPipeWriter();
    using QIODevice::open; // Don't hide base class method
    bool open(Q_PIPE pipe, OpenMode mode);
    bool open(const QString& filename, OpenMode mode);
    void close() override;
    void flush();
    bool isSequential() const override;
    bool isEof() const;
    qint64 bytesToWrite() const override;
    void setLogFile(QFile *logFile, const std::function<QByteArray()>& timestampFn = std::function<QByteArray()>());
    QFile *logFile() const;
    Q_PIPE fd() const;
protected:
    qint64 readData ( char * data, qint64 maxSize ) override;
    qint64 writeData ( const char * data, qint64 maxSize ) override;
Q_SIGNALS:
    void eof();
    void writeError();
private:
    Q_DECLARE_PRIVATE(QPipeWriter)
    Q_DISABLE_COPY(QPipeWriter)
    Q_PRIVATE_SLOT(d_func(), bool _q_canWrite())
    Q_PRIVATE_SLOT(d_func(), void _q_tryOpen())
    // Q_PRIVATE_SLOT(d_func(), void _q_notified())
    const QScopedPointer<QPipeWriterPrivate> d_ptr;
};

#endif
