/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2014-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef FLATCOMMANDLINKBUTTON_H
#define FLATCOMMANDLINKBUTTON_H

#include "widercommandlinkbutton.h"

#include "lgpl_gui_export.h"

class LGPL_GUI_EXPORT FlatCommandLinkButton : public WiderCommandLinkButton
{
    Q_PROPERTY(QColor raisedColour READ raisedColour WRITE setRaisedColour)
    Q_PROPERTY(QColor sunkenColour READ sunkenColour WRITE setSunkenColour)
    Q_PROPERTY(QColor hoverColour READ hoverColour WRITE setHoverColour)
    Q_PROPERTY(QColor lineColour READ lineColour WRITE setLineColour)
    Q_PROPERTY(QColor disabledColour READ disabledColour WRITE setDisabledColour)
public:
    FlatCommandLinkButton(QWidget *parent = 0);
    void setRaisedColour(const QColor& raisedColour);
    QColor raisedColour() const;
    void setSunkenColour(const QColor& sunkenColour);
    QColor sunkenColour() const;
    void setHoverColour(const QColor& hoverColour);
    QColor hoverColour() const;
    void setPressedColour(const QColor& pressedColour);
    QColor pressedColour() const;
    void setDisabledColour(const QColor& disabledColour);
    QColor disabledColour() const;
    void setLineColour(const QColor& lineColour);
    QColor lineColour() const;
    void setTitleColour(const QColor& titleColour);
    QColor titleColour() const;
    void setDescriptionColour(const QColor& setDescriptionColour);
    QColor descriptionColour() const;

    virtual QSize sizeHint() const override;
protected:
    virtual void paintEvent(QPaintEvent * event) override;
    virtual void nextCheckState() override;
private:
    QFont titleFont() const;
    QFont descriptionFont() const;
    
    QRect titleRect() const;
    QRect descriptionRect() const;
    
    int textOffset() const;
    int descriptionOffset() const;

    int topMargin() const { return 10; }
    int leftMargin() const { return 7; }
    int rightMargin() const { return 4; }
    int bottomMargin() const { return 5; }

    QColor mSunkenColour;
    QColor mRaisedColour;
    QColor mHoverColour;
    QColor mPressedColour;
    QColor mDisabledColour;
    QColor mLineColour;
    QColor mTitleColour;
    QColor mDescriptionColour;
};

#endif
