/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (info@qt.nokia.com)
**
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** Other Usage
**
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
** If you have questions regarding the use of this file, please contact
** Nokia at info@qt.nokia.com.
**
**************************************************************************/

#ifndef DETAILSBUTTON_H
#define DETAILSBUTTON_H

#include "lgpl_gui_export.h"
#include <QMap>
#include <QAbstractButton>
#include <QPixmap>
#include "detailswidget_p.h"

QT_FORWARD_DECLARE_CLASS(QGraphicsOpacityEffect)

class LGPL_GUI_EXPORT FadingPanel : public QWidget
{
public:
    FadingPanel(QWidget *parent = 0);
    void setOpacity(qreal value);
    void fadeTo(float value);
protected:
    QGraphicsOpacityEffect *m_opacityEffect;
    bool m_useTransparency;
};

class LGPL_GUI_EXPORT DetailsButton : public QAbstractButton
{
    Q_OBJECT
    Q_PROPERTY(float fader READ fader WRITE setFader)

public:
    struct PixmapCacheKey
    {
        PixmapCacheKey(const QSize &size_, bool checkable_, bool checked_, bool down_ = false, bool hover_ = false, bool enabled_ = true) :
            size(size_),
            checkable(checkable_),
            checked(checked_),
            down(down_),
            hover(hover_),
            enabled(enabled_) {}
        bool operator<(const PixmapCacheKey& other) const;
        QSize size;
        bool checkable;
        bool checked;
        bool down;
        bool hover;
        bool enabled;
    };

    DetailsButton(QWidget *parent = 0);

    QSize sizeHint() const override;
    float fader() const { return m_fader; }
    void setFader(float value) { m_fader = value; update(); }    
    void setDetailButtonText(const QString& expandText, const QString& collapseText);
    QString detailButtonText() const;
    
protected:
    void paintEvent(QPaintEvent *e) override;
    bool event(QEvent *e) override;

private:
    QPixmap cacheRendering(const QSize &size, bool checkable, bool checked, bool down = false, bool hover = false, bool enabled = true);
    QMap<PixmapCacheKey, QPixmap> m_cachedPixmaps;
    float m_fader;
    bool m_useGradient;
    bool m_useTransparency;
    
    QString m_collapseText;
    QString m_expandText;
};

#endif // DETAILSBUTTON_H
