/**
 * Copyright (C) 2023-2025 Linaro Limited (or its affiliates). All rights reserved.
 * Copyright (C) 2012-2023 Arm Limited (or its affiliates).
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#ifndef COROUTINEWAITCONDITION_H
#define COROUTINEWAITCONDITION_H

#include "lgpl_core_export.h"
#include <QList>

class Coroutine;

class LGPL_CORE_EXPORT CoroutineWaitCondition
{
public:
    CoroutineWaitCondition();
    ~CoroutineWaitCondition();
    void wait();
    void wakeOne();
    void wakeAll();
    bool hasWaiters() const;

private:
    QList<Coroutine *> mWaiting;
};

#endif // COROUTINEWAITCONDITION_H
